<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit;
}

if (!isset($_GET['uid'])) {
    die("No user selected");
}

$conn = mysqli_connect("localhost", "root", "", "dubai_treasury_bank");

$uid = (int) $_GET['uid'];

$q = mysqli_query($conn, "SELECT * FROM users WHERE id = $uid LIMIT 1");
if (mysqli_num_rows($q) !== 1) {
    die("User not found");
}

$user = mysqli_fetch_assoc($q);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin View User</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<!-- CUSTOM CSS -->
<link rel="stylesheet" href="assets/admin-view-user.css">
</head>

<body>
<div class="app">

    <!-- TOP HEADER -->
    <div class="top-header">
        <a href="admin-dashboard.php" class="back-icon">
            <i class="bi bi-arrow-left"></i>
        </a>
        <div>
            <small>Admin Panel</small>
            <h4>Managing User</h4>
        </div>
        <i class="bi bi-gear"></i>
    </div>

    <!-- PROFILE CARD -->
    <div class="profile-card">
        <div class="profile-img">
            <i class="bi bi-person-circle"></i>
        </div>
        <div class="profile-info">
            <h4><?php echo htmlspecialchars($user['full_name']); ?></h4>
            <p><strong>Account:</strong> <?php echo htmlspecialchars($user['account_number']); ?></p>
            <p><strong>KYC:</strong> <?php echo htmlspecialchars($user['kyc_status']); ?></p>
        </div>
    </div>

    <!-- WALLET CARD -->
    <div class="wallet-card">
        <p>Account Balance</p>
        <h2>AED <?php echo number_format($user['account_balance'], 2); ?></h2>
        <div class="wallet-footer">
            <span>Admin View</span>
            <span><?php echo htmlspecialchars($user['account_number']); ?></span>
        </div>
    </div>

    <!-- ACTION GRID -->
    <div class="action-grid">
        <a href="admin_edit_user.php?uid=<?php echo $uid; ?>" class="action-box">
            <i class="bi bi-pencil"></i>
            <span>Edit User</span>
        </a>

        <a href="admin_post_transaction.php?uid=<?php echo $uid; ?>" class="action-box">
            <i class="bi bi-plus-circle"></i>
            <span>Add Transaction</span>
        </a>

        <a href="admin-transactions.php?uid=<?php echo $uid; ?>" class="action-box">
            <i class="bi bi-list"></i>
            <span>Transactions</span>
        </a>
    </div>

</div>
</body>
</html>
